package gov.va.med.mhv.phr.chemlabs.portlet;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.phr.chemlabs.decorator.ChemLabsTestDetailsDecorator;
import gov.va.med.mhv.phr.chemlabs.decorator.ChemLabsTestLabDecorator;
import gov.va.med.mhv.phr.chemlabs.decorator.ChemLabsTestLabTableDecorator;
import gov.va.med.mhv.phr.chemlabs.model.ChemLabsRowSorter;
import gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController;
import gov.va.med.mhv.phr.service.ChemLabsTestCollectionServiceResponse;
import gov.va.med.mhv.phr.service.ChemLabsTestLabCollectionServiceResponse;
import gov.va.med.mhv.phr.service.ChemLabsTestPanelCollectionServiceResponse;
import gov.va.med.mhv.phr.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.phr.transfer.ChemLabsTest;
import gov.va.med.mhv.phr.transfer.ChemLabsTestLab;
import gov.va.med.mhv.phr.transfer.ChemLabsTestPanel;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ExtractType;
import gov.va.med.mhv.usermgmt.service.delegate.ActivityAuditServiceDelegate;
import gov.va.med.mhv.usermgmt.transfer.Activity;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.apache.beehive.netui.pageflow.Forward;
import org.apache.beehive.netui.pageflow.annotations.Jpf;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.properties.SortOrderEnum;
import org.tigris.atlas.service.EntityCollectionServiceResponse;


@Jpf.Controller(strutsMerge = "/WEB-INF/struts-override.xml")
public class ChemLabsPageFlowController 
    extends ExtractPageFlowBaseController
{
    private static final long serialVersionUID = 2066922212L;
    
    private static final Log LOG = LogFactory.getLog(
    		ChemLabsPageFlowController.class);    

    private static final String ENTITY_NAME = StringUtils.substringAfterLast(
        ChemLabsTestLab.class.getName(), "."); 
    
    private static final String HELP_PREFIX = "PHR_ChemLabs_";

    private static final String TABLE_UID = "ChemLabs";
    
    private static final String TABLE_SESSION_KEY = 
        "gov.va.med.mhv.phr.chemlabs";

    private static final ExtractType EXTRACT_TYPE = ExtractType.getEnum(
        ExtractType.CHEMISTRYHEMATOLOGY);

    private ChemLabsTestLabDecorator currentLab = null;
    private ChemLabsTestDetailsDecorator currentTest = null;    
    private ArrayList<ChemLabsTest> currentTests = null;
    private ChemLabsTestPanel currentPanel = null;

    @Jpf.Action(forwards = {
        @Jpf.Forward(name = "success", path = "index.jsp"),
        @Jpf.Forward(name = "patient-not-ipa-ed", 
            path="../../common/notInPersonAuthenticated.jsp"),
        @Jpf.Forward(name = "patient-not-correlated", 
           path="../../common/notPatientCorrelated.jsp"),
        @Jpf.Forward(name = "failure", path = "index.jsp")
    })
    @Override
    public Forward begin() {
    	Forward response = super.begin();
    	this.currentLab = null;
    	this.currentTest = null;
    	this.currentPanel = null;
    	handleMessages();
        return response;
    }
    
    @Jpf.Action(
        forwards = { @Jpf.Forward(name = "success", action = "begin") }
    )
    public Forward refresh() {
        Forward forward = new Forward("success");
        return forward;
    }

    /**
     * Callback that is invoked when this controller instance is created.
     */
    @Override
    protected void onCreate() {
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.beehive.EntityPagingListPageFlowController#
     * getTableUID()
     */
    @Override
    public String getTableUID() {
        return TABLE_UID;
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.beehive.EntityPagingListPageFlowController#
     * getDefaultSortProperty()
     */
    @Override
    public Integer getDefaultSortProperty() {
    	return 2; 
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.beehive.EntityPagingListPageFlowController#
     * getDefaultSortOrder()
     */
    @Override
    public SortOrderEnum getDefaultSortOrder() {
        return SortOrderEnum.DESCENDING;
    }

    public String getSortClassName() {
        return ChemLabsRowSorter.class.getName();
    }

    public String getDecoratorClassName() {
        return ChemLabsTestLabTableDecorator.class.getName();
    }

    /* (non-Javadoc)
     * @see org.tigris.atlas.beehive.EntityListMaintenancePageFlowController#
     * getTableSessionKey()
     */
    @Override
    protected String getTableSessionKey() {
        return TABLE_SESSION_KEY;
    }

    /* (non-Javadoc)
     * @see org.tigris.atlas.beehive.EntityMaintenancePageFlowController#
     * getTransferObjectClass()
     */
    @Override
    protected Class getTransferObjectClass() {
        return ChemLabsTestLab.class;
    }

    /* (non-Javadoc)
     * @see org.tigris.atlas.beehive.EntityMaintenancePageFlowController#
     * getEntityName()
     */
    @Override
    protected String getEntityName() {
        return ENTITY_NAME;
    }

    /* (non-Javadoc)
     * @see org.tigris.atlas.beehive.AbstractPageFlowController#getFormClass()
     */
    @Override
    protected Class getFormClass() {
        return ChemLabsPageFlowController.class;
    }

    public ChemLabsTestLabDecorator getCurrentLab() {
        return currentLab;
    }  
    
    public ChemLabsTestDetailsDecorator getCurrentTest() {
        return currentTest;
    }    
    
    public Collection<ChemLabsTestLab> getTestLabs() {
    	Collection<ChemLabsTestLab> result = new ArrayList<ChemLabsTestLab>();
    	Collection entities = this.getEntities();
    	if ( entities != null ) {    		
    		for(Object o : entities) {
    			result.add((ChemLabsTestLab)o);
    		}
    	}
    	return result;
    }
    
    @SuppressWarnings("unchecked")
    public Collection<ChemLabsTestLabTableDecorator> getTestLabTableDecorators() {
    	Collection<ChemLabsTestLabTableDecorator> result = 
            (Collection<ChemLabsTestLabTableDecorator>)getRequest().
            getAttribute("TestLabTableDecorators");
    	if ( result == null ) {
    		Collection<ChemLabsTestLab> entities = getTestLabs();
    		result = new ArrayList<ChemLabsTestLabTableDecorator>();
    		if ( entities != null ) {
    			for(ChemLabsTestLab p : entities) {
    				result.add(new ChemLabsTestLabTableDecorator(p));
    			}	
        	}else{
                if (LOG.isDebugEnabled()) {
                	LOG.info("***** Entities in getTestLabTableDecorators is NULL" + " for patient id: " + getPatient().getId() +
                			" and ICN: " + getPatient().getIcn());
                }        		
        	}
    		getRequest().setAttribute("TestLabTableDecorators", result);
    	}
        return result;
    }
    
    public boolean isPopulated() {
    	if(getTestLabTableDecorators()!=null && getTestLabTableDecorators().size()!=0){
    		return true;
    	}else{
    		return false;
    	}
    }    
   
    
    @Jpf.Action(
        forwards = {@Jpf.Forward(name = "success", path = "indexPF.jsp")}
    )
    public Forward viewPrinterFriendlyIndex() {
        return determineForward();
    }

    @Jpf.Action(
        forwards = {@Jpf.Forward(name = "success", path = "detailsPF.jsp")}
    )
    public Forward viewPrinterFriendlyDetails() {
    	handleMessages();
        return determineForward();
    }
    
    @Jpf.Action(
            forwards = {@Jpf.Forward(name = "success", path = "secondaryDetailsPF.jsp")}
    )
    public Forward viewPrinterFriendlySecondaryDetails() {
        	handleMessages();
            return determineForward();
    }    


    @Jpf.Action(forwards = { 
        @Jpf.Forward(name = "success", path = "index.jsp") 
    })
    @Override
    public Forward returnToListAction() {
    	currentLab = null;
    	handleMessages();
        return super.returnToListAction();
    }

    @Jpf.Action(forwards = { 
        @Jpf.Forward(name = "viewSummary", path = "returnToListAction.do"),
        @Jpf.Forward(name = "viewDetails", path = "details.jsp") 
    })
    public Forward returnToViewAction() {
    	if (currentLab != null) {
    		this.handleMessages();
    		return new Forward("viewDetails");
    	}
        handleMessages();
        return new Forward("viewSummary");
    }
    
    @Jpf.Action(forwards = { 
            @Jpf.Forward(name = "viewSummary", path = "returnToListAction.do"),
            @Jpf.Forward(name = "viewDetails", path = "secondaryDetails.jsp") 
        })
    public Forward returnToSecondaryViewAction() {
    	if (currentTest != null) {
    		this.handleMessages();
    		return new Forward("viewDetails");
    	}
        handleMessages();
        return new Forward("viewSummary");
    }    

    @Jpf.Action(forwards = {
        @Jpf.Forward(name = "success", path = "details.jsp"),
        @Jpf.Forward(name = "failure", path = "index.jsp") 
    })
    /**
     * Loads to the appropriate test lab details and forwards to the
     * associated details view page.
     * @return Forward denoting the details view 
     */
    public Forward viewDetails() {
        Forward forward = null;
        ChemLabsTestLab lab = findLabById(getDetailsId());       
        if (lab != null) {
        	findAllTestsForAllPanelsByLabId(lab);
        	currentLab = new ChemLabsTestLabDecorator(lab);
            forward = determineForward();
        } else {
            forward = determineForwardOnUnknownEntity("view");
        }
        handleMessages();
        return forward;
    }
    
    private void findAllTestsForAllPanelsByLabId(ChemLabsTestLab lab) {
    	// Retrieve test panels for the parent Test lab - lazy loading
    	ChemLabsTestPanelCollectionServiceResponse response = ServiceDelegateFactory.createChemLabsBusinessServiceDelegate().
																findTestPanelsForTestLab(lab.getId());
	    Collection testPanels = response.getChemLabsTestPanels();    
    	if(!testPanels.isEmpty()){
    		currentTests = new ArrayList<ChemLabsTest>();
			for (Iterator iter = testPanels.iterator(); iter.hasNext();) {
    			ChemLabsTestPanel element = (ChemLabsTestPanel) iter.next();
    			
    			// Retrieve tests for the parent Test panels - lazy loading
    	    	ChemLabsTestCollectionServiceResponse testResponse = ServiceDelegateFactory.createChemLabsBusinessServiceDelegate().
										findTestsForTestPanel(element.getId());
    	    	Collection testsForPanels = testResponse.getChemLabsTests();	    			
		    	if(!testsForPanels.isEmpty()){		
	    			for (Iterator iterTests = testsForPanels.iterator(); iterTests.hasNext();) {
		    			ChemLabsTest elementTest = (ChemLabsTest) iterTests.next();
		    			currentTests.add(elementTest);
	    			}
	    		}		    			
			}
    	}else{
    		currentTests = null;
    	}
	}
    

	@Jpf.Action(forwards = {
            @Jpf.Forward(name = "success", path = "secondaryDetails.jsp"),
            @Jpf.Forward(name = "failure", path = "secondaryDetails.jsp") 
        })
    /**
     * Loads to the appropriate test lab details and forwards to the
     * associated details view page.
     * @return Forward denoting the details view 
     */
    public Forward viewSecondaryDetails() {
        Forward forward = null;
        ChemLabsTest test = findChemLabTestsByTestId(getDetailsId());
        if (test != null) {        	
        	currentPanel = test.getChemLabsTestPanel();
            currentTest = new ChemLabsTestDetailsDecorator(test);
            //currentLab is already present in session
            //Populate the currentPanel (parent) for this test  (findChemLabPanelByPanelId)
            
            forward = determineForward();
        } else {
            forward = determineForwardOnUnknownEntity("view");
        }
        handleMessages();
        return forward;
    }    
    
    protected void handleMessages() {
    	if ( currentLab != null && currentLab.getMessages()!=null) {
    		if (currentLab.getMessages().hasErrorMessages() || currentLab.getMessages().hasInformationalMessages()) {
    			handleMessages(currentLab.getMessages());
    		}
    	}
    }
    
    private Long getDetailsId() {
        final String requestID = getRequest().getParameter("id");
        Precondition.assertNotBlank("request.id", requestID);
        Long id = null;
        try {
            id = Long.parseLong(requestID);
        } catch (NumberFormatException e) {
            Precondition.fail("request.id", "a Long", requestID,
                "Unable to determine id for selected test lab.");
        }
        return id;
    }

    private ChemLabsTestLab findLabById(Long id) {
        Collection labs = getTestLabs(); 
        if (labs != null) {
            for(Object p: labs) {            	
            	ChemLabsTestLab lab = (ChemLabsTestLab) p;
                if (id.equals(lab.getId())) { 
                    return lab;
                }
            }
        }
        return null;
    }
    
    
    private ChemLabsTest findChemLabTestsByTestId(Long id) {
        if (currentTests != null) {
            for(Object p: currentTests) {            	
                ChemLabsTest test = (ChemLabsTest) p;
                if (id.equals(test.getId())) { 
                    return test;
                }
            }
        }
        return null;
    }
    
    

    @Jpf.Action(
        forwards = {@Jpf.Forward(name = "success", path = "index.jsp")}
    )
    public Forward handlePagingAndSorting() {
    	handleMessages();
        return super.handlePagingAndSorting();
    }
    
    @Jpf.Action(
            forwards = {@Jpf.Forward(name = "success", path = "details.jsp")}
        )
    public Forward handleDetailsPagingAndSorting() {
    	handleMessages();
        return super.handlePagingAndSorting();
    }    

    /* (non-Javadoc)
     * @see gov.va.med.mhv.pharmacy.portlet.
     * PharmacyMedicationListPageFlowController#getSummaryHelpURI()
     */
    public String getSummaryHelpURI() {
        return createHelpURI(HELP_PREFIX + "SummaryHelp.html");
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.pharmacy.portlet.
     * PharmacyMedicationListPageFlowController#getSummaryHelpURI()
     */
    public String getDetailsHelpURI() {
        return createHelpURI(HELP_PREFIX + "DetailsHelp.html");
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.mhv.pharmacy.portlet.
     * PharmacyMedicationListPageFlowController#getSummaryHelpURI()
     */
    public String getSecondaryDetailsHelpURI() {
        return createHelpURI(HELP_PREFIX + "TestDetailsHelp.html");
    }    

    /* (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * getExtractType()
     */
    @Override
    protected ExtractType getExtractType() {
        return EXTRACT_TYPE;
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * getExtractName()
     */
    @Override
    public String getExtractName() {
        // We cannot use the extract type name, because the enumeration name
        // cannot contain special characters like /
        return "VA Chemistry/Hematology";
    }


    /* (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * getExtractDescription()
     */
    @Override
    protected String getExtractDescription() {
        return "test results";
    }
 

    /*
     * (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * loadExtract()
     */
    @Override
    protected EntityCollectionServiceResponse loadExtract() {            
    	return ServiceDelegateFactory.createChemLabsBusinessServiceDelegate().
    		findTestLabsForPatient(getPatient());
    }

    /*
     * (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * createExtractServiceResponse()
     */
    @Override
    protected EntityCollectionServiceResponse createExtractServiceResponse() {
        return new ChemLabsTestLabCollectionServiceResponse();
    }

    @Jpf.Action(forwards = {
        @Jpf.Forward(name = "success", 
            path="../../common/notInPersonAuthenticated.jsp")
    })
    @Override
    public Forward showNotInPersonAuthenticated() {
        return super.showNotInPersonAuthenticated();
    }
    
    @Override
	protected void auditView() {
		ActivityAuditServiceDelegate auditDelegate =  
		gov.va.med.mhv.usermgmt.service.delegate.
         ServiceDelegateFactory.createActivityAuditServiceDelegate();
		
		Activity activity = 
			TransferObjectFactory.createActivity();
	
		activity.setAction(ActivityActionTypeEnumeration
							.getEnum(ActivityActionTypeEnumeration.VIEW));
		activity.setActionType(ActivityTypeEnumeration.CHEMISTRY_HEMATOLOGY);
		activity.setPerformerType(ActivityActorTypeEnumeration
							.getEnum(ActivityActorTypeEnumeration.SELF));
		activity.setSubjectId(getCurrentUserId());
		activity.setCompletionTime(new java.sql.Timestamp(
							java.util.Calendar.getInstance().getTimeInMillis()));
		activity.setStatus(Boolean.TRUE);
		
		auditDelegate.audit(activity);
	}

	public ChemLabsTestPanel getCurrentPanel() {
		return currentPanel;
	}

	public ArrayList<ChemLabsTest> getCurrentTests() {
		return currentTests;
	}
 
}